<?php
/**
 * Array of settings.
 *
 * @package WC_Shipping_Fedex
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$smartpost_hubs      = include 'data-smartpost-hubs.php';
$smartpost_hubs      = array( '' => __( 'N/A', 'woocommerce-shipping-fedex' ) ) + $smartpost_hubs;
$shipping_class_link = admin_url( 'admin.php?page=wc-settings&tab=shipping&section=classes' );

return array(
	'title'           => array(
		'title'       => __( 'Method Title', 'woocommerce-shipping-fedex' ),
		'type'        => 'text',
		'description' => __( 'This controls the title which the user sees during checkout.', 'woocommerce-shipping-fedex' ),
		'default'     => __( 'FedEx', 'woocommerce-shipping-fedex' ),
		'desc_tip'    => true,
	),
	'origin'          => array(
		'title'       => __( 'Origin Postcode', 'woocommerce-shipping-fedex' ),
		'type'        => 'text',
		'description' => __( 'Enter the postcode for the <strong>sender</strong>.', 'woocommerce-shipping-fedex' ),
		'default'     => '',
		'desc_tip'    => true,
	),
	'tax_status'      => array(
		'title'       => __( 'Tax Status', 'woocommerce-shipping-ups' ),
		'type'        => 'select',
		'description' => '',
		'default'     => 'taxable',
		'options'     => array(
			'taxable' => __( 'Taxable', 'woocommerce-shipping-ups' ),
			'none'    => __( 'None', 'woocommerce-shipping-ups' ),
		),
	),
	'packing'         => array(
		'title'       => __( 'Packages', 'woocommerce-shipping-fedex' ),
		'type'        => 'title',
		'description' => __( 'The following settings determine how items are packed before being sent to FedEx.', 'woocommerce-shipping-fedex' ),
	),
	'packing_method'  => array(
		'title'   => __( 'Parcel Packing Method', 'woocommerce-shipping-fedex' ),
		'type'    => 'select',
		'default' => '',
		'class'   => 'packing_method',
		'options' => array(
			'per_item'    => __( 'Default: Pack items individually', 'woocommerce-shipping-fedex' ),
			'box_packing' => __( 'Recommended: Pack into boxes with weights and dimensions', 'woocommerce-shipping-fedex' ),
		),
	),
	'boxes'           => array(
		'type' => 'box_packing',
	),
	'rates'           => array(
		'title'       => __( 'Rates and Services', 'woocommerce-shipping-fedex' ),
		'type'        => 'title',
		'description' => __( 'The following settings determine the rates you offer your customers.', 'woocommerce-shipping-fedex' ),
	),
	'residential'     => array(
		'title'       => __( 'Residential', 'woocommerce-shipping-fedex' ),
		'label'       => __( 'Default to residential delivery', 'woocommerce-shipping-fedex' ),
		'type'        => 'checkbox',
		'default'     => 'yes',
		'description' => __( 'Enabling this feature will set address classification to RESIDENTIAL when delivery address classification is UNKNOWN or MIXED.', 'woocommerce-shipping-fedex' ),
		'desc_tip'    => true,
	),
	'insure_contents' => array(
		'title'       => __( 'Insurance', 'woocommerce-shipping-fedex' ),
		'label'       => __( 'Enable Insurance', 'woocommerce-shipping-fedex' ),
		'type'        => 'checkbox',
		'default'     => 'yes',
		'desc_tip'    => true,
		'description' => __( 'Sends the package value to FedEx for insurance.', 'woocommerce-shipping-fedex' ),
	),
	'fedex_one_rate'  => array(
		'title'       => __( 'Fedex One', 'woocommerce-shipping-fedex' ),
		// translators: %1$s is an anchor opener with a URL. %2$s is a anchor closer.
		'label'       => sprintf( __( 'Enable %1$sFedex One Rates%2$s', 'woocommerce-shipping-fedex' ), '<a href="https://www.fedex.com/us/onerate/" target="_blank">', '</a>' ),
		'type'        => 'checkbox',
		'default'     => 'no',
		'desc_tip'    => true,
		'description' => __( 'Fedex One Rates will be offered if the items are packed into a valid Fedex One box, and the origin and destination is the US.', 'woocommerce-shipping-fedex' ),
	),
	'request_type'    => array(
		'title'       => __( 'Request Type', 'woocommerce-shipping-fedex' ),
		'type'        => 'select',
		'default'     => 'LIST',
		'class'       => '',
		'desc_tip'    => true,
		'options'     => array(
			'LIST'    => __( 'List rates', 'woocommerce-shipping-fedex' ),
			'ACCOUNT' => __( 'Account rates', 'woocommerce-shipping-fedex' ),
		),
		'description' => __( 'Choose whether to return List or Account (discounted) rates from the API.', 'woocommerce-shipping-fedex' ),
	),
	'smartpost_hub'   => array(
		'title'       => __( 'Fedex SmartPost Hub', 'woocommerce-shipping-fedex' ),
		'type'        => 'select',
		'description' => __( 'Only required if using SmartPost.', 'woocommerce-shipping-fedex' ),
		'desc_tip'    => true,
		'default'     => '',
		'options'     => $smartpost_hubs,
	),
	'offer_rates'     => array(
		'title'       => __( 'Offer Rates', 'woocommerce-shipping-fedex' ),
		'type'        => 'select',
		'description' => '',
		'default'     => 'all',
		'options'     => array(
			'all'      => __( 'Offer the customer all returned rates', 'woocommerce-shipping-fedex' ),
			'cheapest' => __( 'Offer the customer the cheapest rate only, anonymously', 'woocommerce-shipping-fedex' ),
		),
	),
	'services'        => array(
		'type' => 'services',
	),
);
